package gov.va.med.mhv.ssoi;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.stereotype.Component;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.WebKeys;


@Component
public class PreLogoutAction extends Action {

	private static Log log = LogFactoryUtil.getLog(PreLogoutAction.class);

	@Override
	public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
		try {
			HttpSession session = request.getSession();
			/*if((Long)session.getAttribute("Liferay_UserId") != null) {
				User liferayUser = UserLocalServiceUtil.getUserById((Long)session.getAttribute("Liferay_UserId"));
			//User liferayUser = PortalUtil.getUser(request);
			UserLocalServiceUtil.updateLastLogin(liferayUser.getUserId(), liferayUser.getLoginIP());
			}*/
			ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute(WebKeys.THEME_DISPLAY);
			themeDisplay.setSignedIn(false);
			session.invalidate();
			session.removeAttribute("Liferay_UserId");
		} catch (Exception e) {
			log.error("Error in Pre logout", e);
		}
	}

}
